-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.02.10
-- 
-- add system meta db object to standard catalog
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************
 
 -- delete from et_catalog_object_instance where catalog_id < 0;
 -- delete from et_catalog_object where catalog_id < 0;
 
 insert into et_catalog_object (catalog_id, conn_name, object, description, date_activation, ind_active)
 select * from (
 select catalog_id, 'niota_meta' as conn_name, object, description, cast('2000-01-01' as date) as date_activation, 1 as ind_active
   from et_metadb_object
 ) loadval
 on DUPLICATE KEY UPDATE
	description = loadval.description,
	conn_name = loadval.conn_name, 
	object = loadval.object, 
	date_activation = loadval.date_activation, 
	ind_active = loadval.ind_active;
 
 delete from et_catalog_object_instance where catalog_id < 0 and instance_name not in ('*ADMIN');